function FileDialog(x, y, saveable)
{
	var SaveLoad = new Menu(true);
	SaveLoad.itemDraw = ItemDrawAcross;
	SaveLoad.cursorDraw = CursorDrawAcross;
	SaveLoad.addItem("Save", Exit);
	SaveLoad.addItem("Load", Exit);
	var FileSelect = new Menu(true);
	FileSelect.drawwhile = FileInfo;
	var Files = GetFileList();
	for (var i = 0; i < Files.length; i ++)
	{
		FileSelect.addItem(Files[i], Exit);
	}
	var FileMenu = new MenuControl();
	FileMenu.addMenu(SaveLoad, x, y, 172, 18, true, false);
	FileMenu.addMenu(FileSelect, x, y+18, 172, 82, false, false);
	FileMenu.execute();
}

// This displays information on the selected file
function FileInfo(x, y, selection)
{
	var Files = GetFileList();
	var file = OpenFile(Files[selection]);
	
	//window.drawWindow(
}

function Load(filename)
{
	var file = OpenFile(filename);
	Game.money = file.read("Money", 0);
	Game.psize = file.write("Party Size", 0);
	//file.read("Time: Seconds", 0);
	//file.read("Time: Minutes", 0);
	//file.read("Time: Hours", 0);
	Game.accept = file.read("Accept Button", KEY_A);
	Game.cancel = file.read("Cancel Button", KEY_SPACE);
	Game.menu = file.read("Menu Button", KEY_F);
	Game.mainselection = file.read("Main Selection", 0);
	Game.charselection = file.read("Character Selection", 0);
	Game.topcharselection = file.read("Top-Character Selection", 0);
	Game.areamap = file.read("Area", "");
	Game.world = file.read("World", "");
	Game.items = file.read("Items", Game.items);
}

function SaveGame(filename)
{
	var file = OpenFile(filename);
	// Save general info
	file.write("Money:", Game.money);
	file.write("Menu Button:", Game.menu);
	file.write("Area:", Game.areamap);
	file.write("Location:", Game.location);
	// Save item info
	file.write("Items: Amount", Game.items.length);
	for (var i = 0; i < Game.items.length; i ++)
	{
		SaveItem(Game.items[i], "Game: ", i, file);
	}
	// Save character info
	file.write("Party Size:", Game.psize);
	for (var i = 0; i < Game.psize; i ++)
	{
		SaveCharacter(Game.party[i], i, file);
	}
	// Save event info
}

function SaveItem(item, prefix, num, file)
{
	file.write(prefix + "Item #" + num + ": Name", item.name);
	file.write(prefix + "Item #" + num + ": Type", item.type);
	file.write(prefix + "Item #" + num + ": Amount", item.amount);
}

function SaveAbility(ability, prefix, num, file)
{
	file.write(prefix + "Ability #" + num + ": Name", ability.name);
	file.write(prefix + "Ability #" + num + ": Current AP", ability.currentap);
	file.write(prefix + "Ability #" + num + ": Type", ability.type);
}

function SaveIdolix(idolix, prefix, num, file)
{
	file.write(prefix + "Idolix #" + num + ": Name", idolix.name);
	file.write(prefix + "Idolix #" + num + ": LV", idolix.lv);
	file.write(prefix + "Idolix #" + num + ": Abilities", idolix.ability.length);
	for (var i = 0; i < idolix.ability.length; i ++)
	{
		SaveAbility(idolix.ability[i], prefix + "Idolix #" + num + " ", i, file);
	}
}

function SaveCommand(command, prefix, num, file)
{
	file.write(prefix + "Command #" + num + ": Name", command.name);
	file.write(prefix + "Command #" + num + ": To Use", command.touse);
	file.write(prefix + "Command #" + num + ": Enabled", command.enabled);
	if (command.ability == undefined)
	{
		file.write(prefix + "Command #" + num + ": Abilities:", 0);
	}
	else
	{
		file.write(prefix + "Command #" + num + ": Abilities", command.ability.length);
		for (var i = 0; i < command.ability.length; i ++)
		{
			SaveAbility(command.ability[i], prefix + "Command #" + num + " ", i, file);
		}
	}
}

function SaveCharacter(character, num, file)
{
	file.write("Char #" + num +": Name", character.name);
	file.write("Char #" + num +": Max HP", character.maxhp);
	file.write("Char #" + num +": Max MP", character.maxmp);
	file.write("Char #" + num +": LV", character.lv);
	file.write("Char #" + num +": Exp", character.exp);
	file.write("Char #" + num +": Next", character.next);
	file.write("Char #" + num +": Strength", character.strength);
	file.write("Char #" + num +": Speed", character.speed);
	file.write("Char #" + num +": Magic", character.magic);
	file.write("Char #" + num +": Stamina", character.stamina);
	file.write("Char #" + num +": Position", character.position);
	for (var i = 0; i < 5; i ++)
	{
		SaveItem(character.items[i], "Char #" + num + " ", i, file);
	}
	for (var i = 0; i < character.ailments.length; i ++)
	{
		file.write("Char #" + num + " Ailment #" + i + ":", character.ailments[i]);
	}
	for (var i = 0; i < character.idolix.length; i ++)
	{
		SaveIdolix(character.idolix[i], "Char #" + num + " ", i, file);
	}
	for (var i = 0; i < character.ability.length; i ++)
	{
		SaveAbility(character.ability[i], "Char #" + num + " ", i, file);
	}
	for (var i = 0; i < character.commands.length; i ++)
	{
		SaveCommand(character.commands[i], "Char #" + num + " ", i, file);
	}
}